#!/bin/sh
#ATI fglrx driver uninstaller script
#Purpose : Uninstall previously installed ATI Linux Driver
#	  
#Location: It should reside under /[install path]${ATI_UNINST}
#Usage: 
#     - must be root to execute this script
#     - .list files must be present under the same directory
#     - preun/postun related scripts must be present under the same directory
#     - sh fglrx-uninstall.sh [Enter] 
#Warning: do not move this script and relevant files to other location

#check if root
if [ "`whoami`" != "root" ]; then
    echo "[Warning] Uninstall : must be run as root to execute this script"
    exit 1
fi

#move to where the script resides to find all the files to remove
cd `dirname $0`

#try to get the stored variable paths from the previous installation
if [ -f /etc/ati/inst_path_default -a -f /etc/ati/inst_path_override ]; then
    . /etc/ati/inst_path_default
    . /etc/ati/inst_path_override
else
    if [ -n "${FORCE_ATI_UNINSTALL}" ]
    then
        if [ -d /usr/share/ati ]
        then
            SUFFIX=ati
        else
            SUFFIX=fglrx
        fi

        ATI_LOG=/usr/share/${SUFFIX}
        ATI_UNINST=/usr/share/${SUFFIX}
        ATI_DOC=/usr/share/doc/${SUFFIX}
        ATI_KERN_MOD=/lib/modules/fglrx
    else
        echo
        echo "[Warning] Uninstall : inst_path_default or inst_path_override"
        echo " does not exist in /etc/ati.  This suggests that the ATI driver"
        echo " is not installed, the ATI driver is only partially installed,"
        echo " or the current ATI driver installed is an older version than the"
        echo " one this script was designed for.  Both files listed above are"
        echo " required for determining where installed files are located."
        echo " To force uninstallation of the driver by guessing where the"
        echo " uninstallation files are located, set the FORCE_ATI_UNINSTALL"
        echo " environment variable and re-run $0 (this is not recommended)."
        echo
        exit 1
    fi
fi

#check for the location where this script resides, in turn determine the INSTALLPATH
#(the root install dir where the driver components were installed)
CURRENT_DIR=`pwd`
#since we now are in the script directory, SCRIPT_SUBDIR is not really needed
SCRIPT_SUBDIR="."

# the below script replaces all "/"'s with "\/"; escaping the "/"'s for use
#  in the next sed command (where SETUP_INSTALLPATH is created)
ESCAPED_ATI_UNINST=$( echo ${ATI_UNINST} | sed -e 's/\//\\\//g' )

#determine the original loki SETUP_INSTALLPATH
SETUP_INSTALLPATH=`echo "${CURRENT_DIR}/${SCRIPT_SUBDIR}" | sed -e "s/${ESCAPED_ATI_UNINST}.*//g"`

PREUN_PATTERN="preun_*.sh"
POSTUN_PATTERN="postun_*.sh"
PREUN_SCRIPTLIST=`ls ${CURRENT_DIR}/${SCRIPT_SUBDIR}/${PREUN_PATTERN}`
POSTUN_SCRIPTLIST=`ls ${CURRENT_DIR}/${SCRIPT_SUBDIR}/${POSTUN_PATTERN}`
UNINSTALL_FILE_PATTERN="*.list"
UNINSTALL_FILELIST=`ls ${CURRENT_DIR}/${SCRIPT_SUBDIR}/${UNINSTALL_FILE_PATTERN}`

#execute preun scripts
for preun_script in ${PREUN_SCRIPTLIST}
do
    . ${preun_script}    
done

for uninstall_file in ${UNINSTALL_FILELIST}
do
    for libfile in `cat ${uninstall_file}`
    do 

        # Note 1: in the .list file the file begins with "/"
        # therefore no / is needed in between SETUP_INSTALLPATH and libfile 

        # Note 2: we added the -L check because some symlinks are created in
        # ati-installer.sh; -e returns true on a symlink only if that symlink
        # points to a file that exists, while -L always returns true on a
        # symlink

        if [ -e ${SETUP_INSTALLPATH}${libfile} -o -L ${SETUP_INSTALLPATH}${libfile} ]
        then
            rm -f ${SETUP_INSTALLPATH}${libfile}
        fi
    done
done

#execute postun scripts
for postun_script in ${POSTUN_SCRIPTLIST}
do
    . ${postun_script}
done

#remove fglrx related files and directory
if [ $? -eq 0 ]
then
    #preun
    for preun_script in ${PREUN_SCRIPTLIST}
    do
	rm -f ${preun_script} 2>/dev/null
    done
    #postun
    for postun_script in ${POSTUN_SCRIPTLIST}
    do
	rm -f ${postun_script} 2>/dev/null
    done
    #.list files
    for uninstall_file in ${UNINSTALL_FILELIST}
    do
	rm -f ${uninstall_file} 2>/dev/null
    done
    #ATI_LICENSE.TXT
    rm -f ${SETUP_INSTALLPATH}${ATI_LOG}/ATI_LICENSE.TXT 2>/dev/null
    #fglrx-install.log
    rm -f ${SETUP_INSTALLPATH}${ATI_LOG}/fglrx-install.log 2>/dev/null
    #fglrx-uninstall.sh(self)
    rm -f `basename $0` 2>/dev/null

    # remove directories as defined by the policy layer 
    # use rmdir because we still want to preserve the directory if the user
    # put in any file that is not ATI driver related
    rmdir --ignore-fail-on-non-empty ${SETUP_INSTALLPATH}${ATI_SRC} 2>/dev/null
    rmdir --ignore-fail-on-non-empty ${SETUP_INSTALLPATH}${ATI_LOG} 2>/dev/null
    rmdir --ignore-fail-on-non-empty ${SETUP_INSTALLPATH}${ATI_UNINST} 2>/dev/null
    echo "Uninstall fglrx driver complete..." 
    exit 0
else
    echo "Error uninstalling the driver..."
    exit 1
fi

